/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.util.BeeAttribute;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.ColorUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class Gene
extends Item {
    public static final String ATTRIBUTE_KEY = "productivebees_gene_attribute";
    public static final String VALUE_KEY = "productivebees_gene_value";
    public static final String PURITY_KEY = "productivebees_gene_purity";

    public Gene(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack getStack(BeeAttribute<?> attribute, int value) {
        return Gene.getStack(attribute, value, 1);
    }

    public static ItemStack getStack(BeeAttribute<?> attribute, int value, int count) {
        return Gene.getStack(attribute, value, count, ProductiveBees.rand.nextInt(40) + 15);
    }

    public static ItemStack getStack(BeeAttribute<?> attribute, int value, int count, int purity) {
        return Gene.getStack(attribute.toString(), value, count, purity);
    }

    public static ItemStack getStack(String type, int value) {
        return Gene.getStack(type, 0, 1, value);
    }

    public static ItemStack getStack(String attribute, int value, int count, int purity) {
        ItemStack result = new ItemStack((ItemLike)ModItems.GENE.get(), count);
        Gene.setAttribute(result, attribute, value, purity);
        return result;
    }

    public static void setAttribute(ItemStack stack, String attributeId, int value, int purity) {
        stack.m_41784_().m_128359_(ATTRIBUTE_KEY, attributeId);
        stack.m_41784_().m_128405_(VALUE_KEY, value);
        stack.m_41784_().m_128405_(PURITY_KEY, purity);
    }

    @Nullable
    public static BeeAttribute<?> getAttribute(ItemStack stack) {
        String name = Gene.getAttributeName(stack);
        return BeeAttributes.getAttributeByName(name);
    }

    public static String getAttributeName(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128461_(ATTRIBUTE_KEY) : "";
    }

    public static Integer getValue(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_(VALUE_KEY) : 0;
    }

    public static Integer getPurity(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_(PURITY_KEY) : 0;
    }

    public static void setPurity(ItemStack stack, int purity) {
        stack.m_41784_().m_128405_(PURITY_KEY, purity);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, world, list, flag);
        Integer value = Gene.getValue(stack);
        BeeAttribute<?> attribute = Gene.getAttribute(stack);
        if (attribute != null && BeeAttributes.keyMap.containsKey(attribute) && BeeAttributes.keyMap.get(attribute).containsKey(value)) {
            MutableComponent translatedValue = new TranslatableComponent(BeeAttributes.keyMap.get(attribute).get(value)).m_130940_(ColorUtil.getColor(value));
            list.add((Component)new TranslatableComponent("productivebees.information.attribute." + Gene.getAttributeName(stack), new Object[]{translatedValue}).m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)new TextComponent(" (" + Gene.getPurity(stack) + "%)")));
        } else {
            String type = Gene.getAttributeName(stack);
            list.add((Component)new TranslatableComponent("productivebees.information.attribute.type", new Object[]{type}).m_130940_(ChatFormatting.GOLD).m_7220_((Component)new TextComponent(" (" + Gene.getPurity(stack) + "%)")));
        }
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            items.add((Object)Gene.getStack(BeeAttributes.PRODUCTIVITY, 0, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.PRODUCTIVITY, 1, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.PRODUCTIVITY, 2, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.PRODUCTIVITY, 3, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.WEATHER_TOLERANCE, 0, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.WEATHER_TOLERANCE, 1, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.WEATHER_TOLERANCE, 2, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.BEHAVIOR, 0, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.BEHAVIOR, 1, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.BEHAVIOR, 2, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.TEMPER, 0, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.TEMPER, 1, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.TEMPER, 2, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.TEMPER, 3, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.ENDURANCE, 0, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.ENDURANCE, 1, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.ENDURANCE, 2, 1, 100));
            items.add((Object)Gene.getStack(BeeAttributes.ENDURANCE, 3, 1, 100));
        }
    }
}

